/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.improvedmobs.mixin.pathfinding.performance;

import com.flemmli97.improvedmobs.utils.CachedRawPathTypes;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.IBlockReader;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WalkNodeProcessor.class})
public class WalkNodeEvaluatorMixin
implements CachedRawPathTypes {
    private final Long2ObjectMap<PathNodeType> pathTypeByPosCacheRaw = new Long2ObjectOpenHashMap();

    @Inject(method={"postProcess"}, at={@At(value="RETURN")})
    private void reset(CallbackInfo info) {
        this.pathTypeByPosCacheRaw.clear();
    }

    @Inject(method={"getFloorNodeType(Lnet/minecraft/world/IBlockReader;III)Lnet/minecraft/pathfinding/PathNodeType;"}, at={@At(value="HEAD")}, cancellable=true)
    private void isCached(IBlockReader level, int x, int y, int z, CallbackInfoReturnable<PathNodeType> info) {
        long key = SectionPos.func_218166_b((int)x, (int)y, (int)z);
        if (this.pathTypeByPosCacheRaw.containsKey(SectionPos.func_218166_b((int)x, (int)y, (int)z))) {
            info.setReturnValue(this.pathTypeByPosCacheRaw.get(key));
            info.cancel();
        }
    }

    @Inject(method={"getFloorNodeType(Lnet/minecraft/world/IBlockReader;III)Lnet/minecraft/pathfinding/PathNodeType;"}, at={@At(value="RETURN")})
    private void cache(IBlockReader level, int x, int y, int z, CallbackInfoReturnable<PathNodeType> info) {
        this.pathTypeByPosCacheRaw.put(SectionPos.func_218166_b((int)x, (int)y, (int)z), info.getReturnValue());
    }

    @Override
    public Long2ObjectMap<PathNodeType> getPathTypeByPosCacheRaw() {
        return this.pathTypeByPosCacheRaw;
    }
}

